******************************************************************
*** Replication code for "Alliance Complements or Substitutes? ***
*** Explaining Bilateral Intergovernmental Strategic           ***
*** Partnership Ties" by [redacted]                            ***
******************************************************************

*** The code was written in Stata 17.0 BE-Basic Edition ***

*** Please reach out to [redacted] if you have any questions concerning this replication file ***

*** IMPORTANT: This file is accompanied by the "mv_replication_data2.dta" file ***

*** Before proceeding with the replication, please make sure that the following packages are installed: ascod, catplot, coefplot, estout ***

*** To install the asdoc package, use the following command ***

ssc install asdoc, replace

*** To install the coefplot package, use the following command ***

ssc install coefplot, replace

*** To install the estout package, use the following command ***

ssc install estout, replace

*** To install the catplot package, use the following command ***

ssc install catplot, replace

*** Setting the output scheme to black and white ***

set scheme s2mono

***************************************************
*** Replication of the results in the main text ***
***************************************************

*** Figure 3 (catplots) - BISPs across common threat/alliance ***

* Note that in order to produce Figure 3, we must first create a plot of BISPs across common threat, a plot of BISPs across alliance, and then combine the two

* Labelling values of the mid10_common variable
label define mid10_common_label 0 "No common threat" 1 "Common threat"
label values mid10_common mid10_common_label

* Obtaining Pearson's chi squared
tab bisp_tie mid10_common, chi2

* Generating a catplot of bisp_tie over mid10_common
catplot bisp_tie mid10_common, percent (mid10_common) ytitle ("Percent of dyads tied by BISPs", size(small)) intensity(75) asyvars stack blabel(bar, pos(center) format(%4.0f) size(small)) legend(rows(1) stack size(small) order(1 "No BISP ties" 2 "BISP ties") symplacement(center)) saving(component3) recast(bar) note("Pearson Chi2 = 124.23; p < 0.001")

* Labelling values of the alliance_any variable
label define alliance_any_label 0 "No formal alliance" 1 "Formal alliance"
label values alliance_any alliance_any_label

* Obtaining Pearson's chi squared
tab bisp_tie alliance_any, chi2

* Generating a catplot of bisp_tie over alliance_any
catplot bisp_tie alliance_any, percent (alliance_any) ytitle ("Percent of dyads tied by BISPs", size(small)) intensity(75) asyvars stack blabel(bar, pos(center) format(%4.0f) size(small)) legend(rows(1) stack size(small) order(1 "No BISP ties" 2 "BISP ties") symplacement(center)) saving(component4) recast(bar) note("Pearson Chi2 = 144.84; p < 0.001")

* Combining the two plots into a single figures
gr combine component3.gph component4.gph, ycommon ysize(3) xsize(6)

* Exporting the graph
graph export F03.png

*** Figure 4 (catplots) - BISPs across alliance/alliance commitment, common threat subset ***

* Note that in order to produce Figure 4, we must first create a plot of BISPs across alliances, a plot of BISPs across alliance commitments, and then combine the two

* Obtaining Pearson's chi squared
tab bisp_tie alliance_any if mid10_common==1, chi2

* Generating a catplot of bisp_tie over alliance_any, mid10_common subset
* The "if mid10_common==1" condition filters out dyads with no common threat
catplot bisp_tie alliance_any if mid10_common==1, percent (alliance_any) ytitle ("Percent of dyads tied by BISPs", size(small)) intensity(75) asyvars stack blabel(bar, pos(center) format(%4.0f) size(small)) legend(rows(1) stack size(small) order(1 "No BISP ties" 2 "BISP ties") symplacement(center)) saving(component5) recast(bar) note("Pearson Chi2 = 0.10; p = 0.7483")

* Labelling values of the alliance_any variable
label define alliance_commitment_label 0 "No commitment" 1 "Low commitment" 2 "High commitment"
label values alliance_commitment alliance_commitment_label

* Obtaining Pearson's chi squared
tab bisp_tie alliance_commitment if mid10_common==1, chi2

* Generating a catplot of bisp_tie over alliance_commitment, mid10_common subset
* The "if mid10_common==1" condition filters out dyads with no common threat
catplot bisp_tie alliance_commitment if mid10_common==1, percent (alliance_commitment) ytitle ("Percent of dyads tied by BISPs", size(small)) intensity(75) asyvars stack blabel(bar, pos(center) format(%4.0f) size(small)) legend(rows(1) stack size(small) order(1 "No BISP ties" 2 "BISP ties") symplacement(center)) saving(component6) recast(bar) note("Pearson Chi2 = 32.85; p < 0.001")

* Combining the two plots into a single figures
gr combine component5.gph component6.gph, ycommon ysize(3) xsize(6)

* Exporting the graph
graph export F04.png

*** Figure 5 (coefplot) - results of the logistic regression, model 1-4 ***

* Running the logistic regression (Model 1)
* The "ib1." prefix specifies that the reference level should be 1, "Formal alliance"
logit bisp_tie i.mid10_common ib1.alliance_any, vce(cluster id)

* Storing the estimates (Model 1)
estimates store M1a

* Running the logistic regression (Model 2)
* The "##" operator specifies that there should be an interaction between the two variables
logit bisp_tie i.mid10_common##ib1.alliance_any, vce(cluster id)

* Storing the estimates (Model 2)
estimates store M2a

* Running the logistic regression (Model 3)
logit bisp_tie i.mid10_common ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 3)
estimates store M3a

* Running the logistic regression (Model 4)
logit bisp_tie i.mid10_common##ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 4)
estimates store M4a

* Generating coefficient plot
coefplot (M1a, label(No interaction)) (M2a, label(Interaction term)), bylabel(Baseline) || (M3a) (M4a), bylabel(Controls) ||, drop(_cons) xline(0) coeflabels(1.mid10_common = "Common threat" 0.alliance_any = "No formal alliance" trade_log = "Trade value (log)" polity_dif = "Polity difference" ideal_dif = "Foreign policy difference" cinc_dif = "Power differential" 1.mid10 = "Conflict relations" 1.mid10_common#0.alliance_any = "Common threat * No formal alliance")

* Exporting the coefficient plot (Figure 5)
graph export F05.png

*** Figure 6 (interaction plot) - the effect of the interaction between the common threat and alliance variable on the probability of BISP ties ***

* Running the logistic regression (Model 4)
logit bisp_tie i.mid10_common##ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Calculating the margins
margins alliance_any, over(mid10_common)

* Generating the interaction plot
* The "xscale" option changes the scale for purely cosmetic purposes, no effect on the results
marginsplot, recast(scatter) xscale(range(-0.5 1.5)) title("") xtitle("") ytitle("Probability of BISP ties")

* Exporting the coefficient plot (Figure 6)
graph export F06.png

*** Figure 7 (coefplot) - results of the logistic regression, model 5-8 ***

* Running the logistic regression (Model 1)
* The "ib2." prefix specifies that the reference level should be 2, "High alliance commitment"
logit bisp_tie i.mid10_common ib2.alliance_commitment, vce(cluster id)

* Storing the estimates (Model 1)
estimates store M5a

* Running the logistic regression (Model 2)
* The "##" operator specifies that there should be an interaction between the two variables
logit bisp_tie i.mid10_common##ib2.alliance_commitment, vce(cluster id)

* Storing the estimates (Model 2)
estimates store M6a

* Running the logistic regression (Model 3)
logit bisp_tie i.mid10_common ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 3)
estimates store M7a

* Running the logistic regression (Model 4)
logit bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 4)
estimates store M8a

* Generating coefficient plot
coefplot (M5a, label(No interaction)) (M6a, label(Interaction term)), bylabel(Baseline) || (M7a) (M8a), bylabel(Controls) ||, drop(_cons) xline(0) coeflabels(1.mid10_common = "Common threat" 0.alliance_commitment = "No commitment" 1.alliance_commitment = "Low commitment"  trade_log = "Trade value (log)" polity_dif = "Polity difference" ideal_dif = "Foreign policy difference" cinc_dif = "Power differential" 1.mid10 = "Conflict relations" 1.mid10_common#0.alliance_commitment = "Common threat * No commitment" 1.mid10_common#1.alliance_commitment = "Common threat * Low commitment")

* Exporting the coefficient plot (Figure 7)
graph export F07.png

*** Figure 8 (interaction plot) - the effect of the interaction between the common threat and alliance commitment variable on the probability of BISP ties ***

* Running the logistic regression (Model 8)
logit bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Calculating the margins
margins alliance_commitment, over(mid10_common)

* Generating the interaction plot
* The "xscale" option changes the scale for purely cosmetic purposes, no effect on the results
marginsplot, recast(scatter) xscale(range(-0.5 2.5)) title("") xtitle("") ytitle("Probability of BISP ties")

* Exporting the coefficient plot (Figure 8)
graph export F08.png

************************************************
*** Replication of the results in Appendix 1 ***
************************************************

*** Table 1 (cross-tabs) - BISP across common threat ***

* Generating the table
asdoc tab mid10_common bisp_tie, title(Table 1: Cross-tabulations of BISP ties across common threat) exp row chi2 save(A01T01.rtf)

*** Table 2 (cross-tabs) - BISP across alliance ***

* Generating the table
asdoc tab alliance_any bisp_tie, title(Table 1: Cross-tabulations of BISP ties across alliance) exp row chi2 save(A01T02.rtf)

*** Table 3 (cross-tabs) - BISP across alliance, common threat subset ***

* Generating the table
asdoc tab alliance_any bisp_tie if mid10_common==1, title(Table 1: Cross-tabulations of BISP ties across alliance, common threat subset) exp row chi2 save(A01T03.rtf)

*** Table 4 (cross-tabs) - BISP across alliance commitment, common threat subset ***

* Generating the table
asdoc tab alliance_commitment bisp_tie if mid10_common==1, title(Table 1: Cross-tabulations of BISP ties across alliance commitments, common threat subset) exp row chi2 save(A01T04.rtf)

************************************************
*** Replication of the results in Appendix 2 ***
************************************************

*** Table 1 - results of the logistic regression, model 1-4 ***

* Generating a table with the results 
esttab M1a M2a M3a M4a using A02T01.rtf, noeqlines eqlabels(none) nogaps se pr2 varlabels(1.mid10_common "Common threat" 0.alliance_any "No formal alliance" 1.mid10_common#0.alliance_any "Common threat * No formal alliance" trade_log "Trade value (log)" polity_dif "Polity difference" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 1.alliance_any 0.mid10_common#0.alliance_any 0.mid10_common#1.alliance_any 1.mid10_common#1.alliance_any 0.mid10) title(Table 1: Logistic regression of BISP ties) nonumbers mlabels("Model 1" "Model 2" "Model 3" "Model 4")

*** Table 2 - margins for the mid10_common##alliance_any interaction ***

* Running the logistic regression (Model 4)
logit bisp_tie i.mid10_common##ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Generating the table with margins
asdoc margins alliance_any, over(mid10_common) save(A02T02.rtf)

*** Figure 1 - ROC curve (Model 1-4) ***

* Running the logistic regression (Model 1)
logit bisp_tie i.mid10_common ib1.alliance_any, vce(cluster id)

* Generating the ROC curve
lroc, title("Model 1") saving(component7)

* Running the logistic regression (Model 2)
logit bisp_tie i.mid10_common##ib1.alliance_any, vce(cluster id)

* Generating the ROC curve
lroc, title("Model 2") saving(component8)

* Running the logistic regression (Model 3)
logit bisp_tie i.mid10_common ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Generating the ROC curve
lroc, title("Model 3") saving(component9)

* Running the logistic regression (Model 4)
logit bisp_tie i.mid10_common##ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Generating the ROC curve
lroc, title("Model 4") saving(component10)

* Combining the four plots into a single figures
gr combine component7.gph component8.gph component9.gph component10.gph, ycommon ysize(6) xsize(6)

* Exporting the graph
graph export A02F01.png

*** Table 3 - results of the logistic regression, model 5-8 ***

* Generating a table with the results 
esttab M5a M6a M7a M8a using A02T03.rtf, noeqlines eqlabels(none) nogaps se pr2 varlabels(1.mid10_common "Common threat" 0.alliance_commitment "No commitment" 1.alliance_commitment "Low commitment" 1.mid10_common#0.alliance_commitment "Common threat * No commitment" 1.mid10_common#1.alliance_commitment "Common threat * Low commitment" trade_log "Trade value (log)" polity_dif "Polity difference" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 2.alliance_commitment 0.mid10_common#0.alliance_commitment 0.mid10_common#1.alliance_commitment 0.mid10_common#2.alliance_commitment 1.mid10_common#2.alliance_commitment 0.mid10) title(Table 1: Logistic regression of BISP ties) nonumbers mlabels("Model 5" "Model 6" "Model 7" "Model 8")

*** Table 4 - margins for the mid10_common##alliance_commitment interaction ***

* Running the logistic regression (Model 8)
logit bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Generating the table with margins
asdoc margins alliance_commitment, over(mid10_common) save(A02T04.rtf)

*** Figure 2 - ROC curve (Model 5-8) ***

* Running the logistic regression (Model 5)
logit bisp_tie i.mid10_common ib2.alliance_commitment, vce(cluster id)

* Generating the ROC curve
lroc, title("Model 5") saving(component11)

* Running the logistic regression (Model 6)
logit bisp_tie i.mid10_common##ib2.alliance_commitment, vce(cluster id)

* Generating the ROC curve
lroc, title("Model 6") saving(component12)

* Running the logistic regression (Model 7)
logit bisp_tie i.mid10_common ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Generating the ROC curve
lroc, title("Model 7") saving(component13)

* Running the logistic regression (Model 8)
logit bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Generating the ROC curve
lroc, title("Model 8") saving(component14)

* Combining the four plots into a single figures
gr combine component11.gph component12.gph component13.gph component14.gph, ycommon ysize(6) xsize(6)

* Exporting the graph
graph export A02F02.png

************************************************
*** Replication of the results in Appendix 3 ***
************************************************

*** Table 1 - results of the probit regression, model 1-4 ***

* Running the logistic regression (Model 1)
probit bisp_tie i.mid10_common ib1.alliance_any, vce(cluster id)

* Storing the estimates (Model 1)
estimates store M1b

* Running the logistic regression (Model 2)
probit bisp_tie i.mid10_common##ib1.alliance_any, vce(cluster id)

* Storing the estimates (Model 2)
estimates store M2b

* Running the logistic regression (Model 3)
probit bisp_tie i.mid10_common ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 3)
estimates store M3b

* Running the logistic regression (Model 4)
probit bisp_tie i.mid10_common##ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 4)
estimates store M4b

* Generating a table with the results 
esttab M1b M2b M3b M4b using A03T01.rtf, noeqlines eqlabels(none) nogaps se pr2 varlabels(1.mid10_common "Common threat" 0.alliance_any "No formal alliance" 1.mid10_common#0.alliance_any "Common threat * No formal alliance" trade_log "Trade value (log)" polity_dif "Polity difference" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 1.alliance_any 0.mid10_common#0.alliance_any 0.mid10_common#1.alliance_any 1.mid10_common#1.alliance_any 0.mid10) title(Table 1: Probit regression of BISP ties) nonumbers mlabels("Model 1" "Model 2" "Model 3" "Model 4")

*** Table 2 - results of the probit regression, model 5-8 ***

* Running the logistic regression (Model 5)
probit bisp_tie i.mid10_common ib2.alliance_commitment, vce(cluster id)

* Storing the estimates (Model 5)
estimates store M5b

* Running the logistic regression (Model 6)
probit bisp_tie i.mid10_common##ib2.alliance_commitment, vce(cluster id)

* Storing the estimates (Model 6)
estimates store M6b

* Running the logistic regression (Model 7)
probit bisp_tie i.mid10_common ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 7)
estimates store M7b

* Running the logistic regression (Model 8)
probit bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 8)
estimates store M8b

* Generating a table with the results 
esttab M5b M6b M7b M8b using A03T02.rtf, noeqlines eqlabels(none) nogaps se pr2 varlabels(1.mid10_common "Common threat" 0.alliance_commitment "No commitment" 1.alliance_commitment "Low commitment" 1.mid10_common#0.alliance_commitment "Common threat * No commitment" 1.mid10_common#1.alliance_commitment "Common threat * Low commitment" trade_log "Trade value (log)" polity_dif "Polity difference" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 2.alliance_commitment 0.mid10_common#0.alliance_commitment 0.mid10_common#1.alliance_commitment 0.mid10_common#2.alliance_commitment 1.mid10_common#2.alliance_commitment 0.mid10) title(Table 1: Probit regression of BISP ties) nonumbers mlabels("Model 5" "Model 6" "Model 7" "Model 8")

************************************************
*** Replication of the results in Appendix 4 ***
************************************************

* NOTE 1: Please run the "nclogit.ado" file (available at https://github.com/jscarlson/stata-dcr) before running the code for DCRSE models!
* NOTE 2: Please change the directory before exporting the results!

* Running the .do file
do "C:/.../dcr.ado"

*** Table 1 - results of the logistic regression with DCRSE, model 1-4 ***

* Running the logistic regression with DCRSE (Model 1)
dcr logit bisp_tie i.mid10_common ib1.alliance_any, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse1.xlsx)

* Running the logistic regression with DCRSE (Model 2)
dcr logit bisp_tie i.mid10_common##ib1.alliance_any, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse2.xlsx)

* Running the logistic regression with DCRSE (Model 3)
dcr logit bisp_tie i.mid10_common ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse3.xlsx)

* Running the logistic regression with DCRSE (Model 4)
dcr logit bisp_tie i.mid10_common##ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse4.xlsx)

*** Table 2 - results of the logistic regression with DCRSE, model 5-8 ***

* Running the logistic regression with DCRSE (Model 5)
dcr logit bisp_tie i.mid10_common ib2.alliance_commitment, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse5.xlsx)

* Running the logistic regression with DCRSE (Model 6)
dcr logit bisp_tie i.mid10_common##ib2.alliance_commitment, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse6.xlsx)

* Running the logistic regression with DCRSE (Model 7)
dcr logit bisp_tie i.mid10_common ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse7.xlsx)

* Running the logistic regression with DCRSE (Model 8)
dcr logit bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse8.xlsx)

************************************************
*** Replication of the results in Appendix 5 ***
************************************************

*** Table 1 - results of the probit regression with DCRSE, model 1-4 ***

* Running the probit regression with DCRSE (Model 1)
dcr probit bisp_tie i.mid10_common ib1.alliance_any, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse9.xlsx)

* Running the probit regression with DCRSE (Model 2)
dcr probit bisp_tie i.mid10_common##ib1.alliance_any, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse10.xlsx)

* Running the probit regression with DCRSE (Model 3)
dcr probit bisp_tie i.mid10_common ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse11.xlsx)

* Running the probit regression with DCRSE (Model 4)
dcr probit bisp_tie i.mid10_common##ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse12.xlsx)

*** Table 2 - results of the probit regression with DCRSE, model 5-8 ***

* Running the probit regression with DCRSE (Model 5)
dcr probit bisp_tie i.mid10_common ib2.alliance_commitment, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse13.xlsx)

* Running the probit regression with DCRSE (Model 6)
dcr probit bisp_tie i.mid10_common##ib2.alliance_commitment, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse14.xlsx)

* Running the probit regression with DCRSE (Model 7)
dcr probit bisp_tie i.mid10_common ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse15.xlsx)

* Running the probit regression with DCRSE (Model 8)
dcr probit bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, dm1(ccodea) dm2(ccodeb) dofundo(reglike) xlsxpath(C:/.../dcrse16.xlsx)

************************************************
*** Replication of the results in Appendix 6 ***
************************************************

*** Table 1 - VIF scores, model 1-4 ***

* Running the OLS regression (Model 1)
regres bisp_tie i.mid10_common ib1.alliance_any, vce(cluster id)
asdoc vif, save(A06T01.rtf)

* Storing the estimates (Model 1)
estimates store M1c

* Running the OLS regression (Model 2)
* The "##" operator specifies that there should be an interaction between the two variables
regres bisp_tie i.mid10_common##ib1.alliance_any, vce(cluster id)
asdoc vif, append(A06T01.rtf)

* Storing the estimates (Model 2)
estimates store M2c

* Running the OLS regression (Model 3)
regres bisp_tie i.mid10_common ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)
asdoc vif, append(A06T01.rtf)

* Storing the estimates (Model 3)
estimates store M3c

* Running the OLS regression (Model 4)
regres bisp_tie i.mid10_common##ib1.alliance_any c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)
asdoc vif, append(A06T01.rtf)

* Storing the estimates (Model 4)
estimates store M4c

*** Table 2 - results of the OLS regression, model 1-4 ***

* Generating a table with the results 
esttab M1c M2c M3c M4c using A06T02.rtf, noeqlines eqlabels(none) nogaps se r2 varlabels(1.mid10_common "Common threat" 0.alliance_any "No formal alliance" 1.mid10_common#0.alliance_any "Common threat * No formal alliance" trade_log "Trade value (log)" polity_dif "Polity difference" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 1.alliance_any 0.mid10_common#0.alliance_any 0.mid10_common#1.alliance_any 1.mid10_common#1.alliance_any 0.mid10) title(Table 1: OLS regression of BISP ties) nonumbers mlabels("Model 1" "Model 2" "Model 3" "Model 4")

*** Table 3 - VIF scores, model 5-8 ***

* Running the OLS regression (Model 5)
regres bisp_tie i.mid10_common ib2.alliance_commitment, vce(cluster id)
asdoc vif, save(A06T03.rtf)

* Storing the estimates (Model 5)
estimates store M5c

* Running the OLS regression (Model 6)
* The "##" operator specifies that there should be an interaction between the two variables
regres bisp_tie i.mid10_common##ib2.alliance_commitment, vce(cluster id)
asdoc vif, append(A06T03.rtf)

* Storing the estimates (Model 6)
estimates store M6c

* Running the OLS regression (Model 7)
regres bisp_tie i.mid10_common ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)
asdoc vif, append(A06T03.rtf)

* Storing the estimates (Model 7)
estimates store M7c

* Running the OLS regression (Model 8)
regres bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log c.polity_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)
asdoc vif, append(A06T03.rtf)

* Storing the estimates (Model 8)
estimates store M8c

*** Table 4 - results of the OLS regression, model 5-8 ***

* Generating a table with the results 
esttab M5c M6c M7c M8c using A06T04.rtf, noeqlines eqlabels(none) nogaps se r2 varlabels(1.mid10_common "Common threat" 0.alliance_commitment "No commitment" 1.alliance_commitment "Low commitment" 1.mid10_common#0.alliance_commitment "Common threat * No commitment" 1.mid10_common#1.alliance_commitment "Common threat * Low commitment" trade_log "Trade value (log)" polity_dif "Polity difference" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 2.alliance_commitment 0.mid10_common#0.alliance_commitment 0.mid10_common#1.alliance_commitment 0.mid10_common#2.alliance_commitment 1.mid10_common#2.alliance_commitment 0.mid10) title(Table 1: OLS regression of BISP ties) nonumbers mlabels("Model 5" "Model 6" "Model 7" "Model 8")

************************************************
*** Replication of the results in Appendix 7 ***
************************************************

*** Figure 1 (coefficient plot) - results of the logistic regression, Model 9 ***

* Running the logistic regression (Model 9)
logit bisp_tie i.mid10_common##ib1.alliance_any##c.polity_dif c.trade_log c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 9)
estimates store M9

* Generating coefficient plot
coefplot M9 ||, drop(_cons) xline(0) coeflabels(1.mid10_common = "Common threat" 0.alliance_any = "No formal alliance" trade_log = "Trade value (log)" polity_dif = "Polity difference" ideal_dif = "Foreign policy difference" cinc_dif = "Power differential" 1.mid10 = "Conflict relations" 1.mid10_common#0.alliance_any = "Common threat * No formal alliance" 1.mid10_common#c.polity_dif = "Common threat * Polity difference" 0.alliance_any#c.polity_dif = "No formal alliance * Polity difference" 1.mid10_common#0.alliance_any#c.polity_dif = "Common threat * No formal alliance * Polity difference")

* Exporting the coefficient plot (Appendix 7, Figure 1)
graph export A07F01.png

*** Figure 1 (interaction plot) - the effect of the interaction between variables common threat, alliance commitment, and polity difference on the probability of BISP ties *** 

* Calculating the margins
margins mid10_common, over(alliance_any) at(polity_dif=(0(2)20))

* Generating the interaction plot
marginsplot, xdimension(polity_dif) bydimension(alliance_any) byopts(title("") col(1)) ytitle("Probability of BISP ties") xtitle("Polity difference") ysize(6) xsize(5)

* Exporting the interaction plot (Appendix 7, Figure 2)
graph export A07F02.png

*** Figure 2 (coefficient plot) - results of the logistic regression, Model 10 ***

* Running the logistic regression (Model 10)
logit bisp_tie i.mid10_common##ib2.alliance_commitment##c.polity_dif c.trade_log c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 10)
estimates store M10

* Generating coefficient plot
coefplot M10 ||, drop(_cons) xline(0) coeflabels(1.mid10_common = "Common threat" 0.alliance_commitment = "No commitment" 1.alliance_commitment = "Low commitment"  trade_log = "Trade value (log)" polity_dif = "Polity difference" ideal_dif = "Foreign policy difference" cinc_dif = "Power differential" 1.mid10 = "Conflict relations" 1.mid10_common#0.alliance_commitment = "Common threat * No commitment" 1.mid10_common#1.alliance_commitment = "Common threat * Low commitment" 1.mid10_common#c.polity_dif = "Common threat * Polity difference" 0.alliance_commitment#c.polity_dif = "No commitment * Polity difference" 1.alliance_commitment#c.polity_dif = "Low commitment * Polity difference" 1.mid10_common#0.alliance_commitment#c.polity_dif = "Common threat * No commitment * Polity difference" 1.mid10_common#1.alliance_commitment#c.polity_dif = "Common threat * Low commitment * Polity difference")

* Exporting the coefficient plot (Appendix 7, Figure 1)
graph export A07F03.png

*** Figure 1 (interaction plot) - the effect of the interaction between variables common threat, alliance commitment, and polity difference on the probability of BISP ties *** 

* Calculating the margins
margins mid10_common, over(alliance_commitment) at(polity_dif=(0(2)20))

* Generating the interaction plot
marginsplot, xdimension(polity_dif) bydimension(alliance_commitment) byopts(title("") col(1)) ytitle("Probability of BISP ties") xtitle("Polity difference") ysize(6) xsize(5)

* Exporting the interaction plot (Appendix 7, Figure 2)
graph export A07F04.png

************************************************
*** Replication of the results in Appendix 8 ***
************************************************

*** Table 1 - results of the logistic regression with dummies for regime similarity/difference, model 11-12 ***

* Running the logistic regression (Model 11)
logit bisp_tie i.mid10_common ib1.alliance_any c.trade_log i.joint_dem i.joint_auto i.mixed_regime c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 11)
estimates store M11

* Running the logistic regression (Model 12)
logit bisp_tie i.mid10_common##ib1.alliance_any c.trade_log i.joint_dem i.joint_auto i.mixed_regime c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 12)
estimates store M12

* Generating a table with the results 
esttab M11 M12 using A08T01.rtf, noeqlines eqlabels(none) nogaps se pr2 varlabels(1.mid10_common "Common threat" 0.alliance_any "No formal alliance" 1.mid10_common#0.alliance_any "Common threat * No formal alliance" trade_log "Trade value (log)" 1.joint_dem "Joint democracy" 1.joint_auto "Joint autocracy" 1.mixed_regime "Mixed regime dyad" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 1.alliance_any 0.mid10_common#0.alliance_any 0.mid10_common#1.alliance_any 1.mid10_common#1.alliance_any 0.mid10 0.joint_dem 0.joint_auto 0.mixed_regime) title(Table 1: Logistic regression of BISP ties) nonumbers mlabels("Model 11" "Model 12")

*** Table 2 - results of the logistic regression with the electoral democracy index difference, model 13-14 ***

* Running the logistic regression (Model 13)
logit bisp_tie i.mid10_common ib1.alliance_any c.trade_log c.polyarchy_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 13)
estimates store M13

* Running the logistic regression (Model 14)
logit bisp_tie i.mid10_common##ib1.alliance_any c.trade_log c.polyarchy_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 14)
estimates store M14

* Generating a table with the results
esttab M13 M14 using A08T02.rtf, noeqlines eqlabels(none) nogaps se pr2 varlabels(1.mid10_common "Common threat" 0.alliance_any "No formal alliance" 1.mid10_common#0.alliance_any "Common threat * No formal alliance" trade_log "Trade value (log)" polyarchy_dif "Electoral democracy index difference" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 1.alliance_any 0.mid10_common#0.alliance_any 0.mid10_common#1.alliance_any 1.mid10_common#1.alliance_any 0.mid10) title(Table 1: Logistic regression of BISP ties) nonumbers mlabels("Model 13" "Model 14")

*** Table 3 - results of the logistic regression with dummies for regime similarity/difference, model 15-16 ***

* Running the logistic regression (Model 15)
logit bisp_tie i.mid10_common ib2.alliance_commitment c.trade_log i.joint_dem i.joint_auto i.mixed_regime c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 15)
estimates store M15

* Running the logistic regression (Model 16)
logit bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log i.joint_dem i.joint_auto i.mixed_regime c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 16)
estimates store M16

* Generating a table with the results 
esttab M15 M16 using A08T03.rtf, noeqlines eqlabels(none) nogaps se pr2 varlabels(1.mid10_common "Common threat" 0.alliance_commitment "No commitment" 1.alliance_commitment "Low commitment" 1.mid10_common#0.alliance_commitment "Common threat * No commitment" 1.mid10_common#1.alliance_commitment "Common threat * Low commitment" trade_log "Trade value (log)" 1.joint_dem "Joint democracy" 1.joint_auto "Joint autocracy" 1.mixed_regime "Mixed regime dyad" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 2.alliance_commitment 0.mid10_common#0.alliance_commitment 0.mid10_common#1.alliance_commitment 0.mid10_common#2.alliance_commitment 1.mid10_common#2.alliance_commitment 0.mid10 0.joint_dem 0.joint_auto 0.mixed_regime) title(Table 1: Logistic regression of BISP ties) nonumbers mlabels("Model 15" "Model 16")

*** Table 4 - results of the logistic regression with the electoral democracy index difference, model 17-18 ***

* Running the logistic regression (Model 17)
logit bisp_tie i.mid10_common ib2.alliance_commitment c.trade_log c.polyarchy_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 17)
estimates store M17

* Running the logistic regression (Model 18)
logit bisp_tie i.mid10_common##ib2.alliance_commitment c.trade_log c.polyarchy_dif c.ideal_dif c.cinc_dif i.mid10, vce(cluster id)

* Storing the estimates (Model 18)
estimates store M18

* Generating a table with the results
esttab M17 M18 using A08T04.rtf, noeqlines eqlabels(none) nogaps se pr2 varlabels(1.mid10_common "Common threat" 0.alliance_commitment "No commitment" 1.alliance_commitment "Low commitment" 1.mid10_common#0.alliance_commitment "Common threat * No commitment" 1.mid10_common#1.alliance_commitment "Common threat * Low commitment" trade_log "Trade value (log)" polyarchy_dif "Electoral democracy index difference" ideal_dif "Foreign policy difference" cinc_dif "Power differential" 1.mid10 "Conflict relations" _cons "Constant") drop(0.mid10_common 2.alliance_commitment 0.mid10_common#0.alliance_commitment 0.mid10_common#1.alliance_commitment 0.mid10_common#2.alliance_commitment 1.mid10_common#2.alliance_commitment 0.mid10) title(Table 1: Logistic regression of BISP ties) nonumbers mlabels("Model 17" "Model 18")

****************************
*** End replication here ***
****************************