******************************************************************
*** Replication code for "Alliance Complements or Substitutes? ***
*** Explaining the Emergence of Bilateral Intergovernmental    ***
*** Strategic Partnerships" by [redacted]                      ***
******************************************************************

*** The code was written in Stata 17.0 BE-Basic Edition ***

*** Please reach out to [redacted] if you have any questions concerning this replication file ***

*** IMPORTANT: This file is accompanied by the "mv_replication_data1.dta" file ***

*** Setting the output scheme to black and white ***

set scheme s2mono

***********************************************
*** Replication of figures in the main text ***
***********************************************

*** Figure 1 (panel-data line plots) - BISP count over time by G20 country ***

* Declaring data as panel data
xtset ccode year

* Labelling values of the ccode variable
label define ccode_label 2 "United States" 20 "Canada" 70 "Mexico" 140 "Brazil" 160 "Argentina" 200 "United Kingdom" 220 "France" 255 "Germany" 325 "Italy" 365 "Russia" 560 "South Africa" 640 "Turkey" 670 "Saudi Arabia" 710 "China" 732 "South Korea" 740 "Japan" 750 "India" 850 "Indonesia" 900 "Australia" 999 "G20"
label values ccode ccode_label

* Labelling the bisp_total variable
label var bisp_total "BISPs"

* Labelling the year variable
label var year "Year"

* Labelling the year variable
label var ccode "G20 country"

* Generating panel-data line plots for the bisp_total variable
* Note that the "ccode<999 & year>1989" condition serves to filter out observations for G20 as a whole ("999" in the dataset) and years prior to the year 1990 (no observations)
xtline bisp_total if ccode<999 & year>1989, yscale(range(5 100)) ylabel(0(50)100) tscale(range(1990 2020)) tlabel(1990 2000 2010 2020)

* Exporting the graph
graph export F01.png

*** Figure 2 (line plots) - Formal IO, informal IO, formal alliance, and BISP count over time at the G20 level ***

* Note that in order to produce Figure 2, we must first create a plot of formal and informal IOs over time, a plot of formal alliances and BISPs over time, and then combine the two

* Labelling the figo_total variable
label var figo_total "Formal IOs"

* Labelling the iigo_total variable
label var iigo_total "Informal IOs"

* Labelling the alliance_total variable
label var alliance_total "Formal alliances"

* Generating the plot of formal and informal IOs over time
tsline figo_total iigo_total if ccode==999, yscale(range(0 400)) ylabel(0(100)400) ytitle("Count") saving(component1) 

* Generating the plot of formal alliances and BISPs over time
tsline alliance_total bisp_total if ccode==999, yscale(range(0 400)) ylabel(0(100)400) ytitle("Count") saving(component2)

* Combining the two plots into a single figures
gr combine component1.gph component2.gph, ycommon ysize(3) xsize(6)

* Exporting the graph
graph export F02.png

******************************************
*** Continue with mv_replication_code2 ***
******************************************